%% plot2d1.m

%% Function to plot two-dimensional representation of the FOU of an interval 
%% type-2 fuzzy set (see, for example, Figures 3-8 and 3-9). The area between
%% the upper and lower membership functions is shaded uniformly to indicate
%% that all the secondary grades are unity.

 
%% Written by Nilesh N. Karnik - August 18,1998
%% For use with MATLAB version 4.2c or higher

%% Outputs : None. The function plots the required type-2 set in the 
%% active figure window.

%% Inputs : "upper", "lower" and "xaxis" are all vectors having the 
%% same length. "upper" and "lower", contain  the y-coordinates of the 
%% upper bound and the lower bound, respectively; and, "xaxis" 
%% contains the x-coordinates of these functions.
 
%% NOTE : If lighter/darker shading is desired, the value of  
%% "grey_color" should be increased/decresed ("0 < grey_color < 1").


function [] = plot2d1(upper, lower, xaxis) 

grey_color = 0.8 ;
grey = grey_color*ones(1,3) ;

xfill = [xaxis fliplr(xaxis)] ;
yfill = [upper fliplr(lower)] ;

fill(xfill,yfill,grey) ;


return ;
